<div class="widget">
  <div class="widget-advanced widget-advanced-alt">
    <div class="widget-main">
				<h3>
					<strong>LandingRate</strong> Records <br><small>The feather landings</small>
				</h3>
			
			<div class="alert alert-success alert-dismissable animation fadeIn">
			  Whenever a pilot achives a landing rate below '-100 fpm' it is considered as a greased landing. With every such landing, this table is automatically updated.
			</div>
			<div style="overflow: auto; height: 350px; border: 0px solid #666; margin-bottom: 20px; padding: 5px; padding-top: 0px; padding-bottom: 20px;">
			<table class="table table-striped tabled-hover">
				
			<thead>
				<th>ID</th>
				<th>Pilot Name</th>
				<th>Landing Rate</th>
				<th>Record Created at</th>
				<th>Record Created On</th>
			</thead>
    
<?php
    foreach($stats as $stat)
    { 
       $pilot = PilotData::getPilotData($stat->pilotid);
        $aircraft = OperationsData::getAircraftInfo($stat->aircraft);
      $lr = $stat->landingrate;
      
       if($lr > -40)
{
  $textclr = 'success';
}
else if($lr > -60)
{
  $textclr = 'warning';
}
else if($lr > -80)
{
  $textclr = 'info';
}
else if($lr > -90)
{
  $textclr = 'danger';
}

       
        echo '<tr>';
        echo '<td><a class="btn btn-info btn-sm" href="'.SITE_URL.'/index.php/profile/view/'.$pilot->id.'">'.PilotData::getPilotCode($pilot->code, $pilot->pilotid).'</a></td>';
        echo '<td>'.$pilot->firstname.' '.$pilot->lastname.'</td>';
        echo '<td class="text-'.$textclr.'">'.$stat->landingrate.'</td>';
	      echo '<td>'.$stat->arricao.'</td>';
        echo '<td>'.date(DATE_FORMAT, strtotime($stat->submitdate)).'</td>';
        echo '</tr>';
    }
?>

</table>
</div>
</div>
</div></div>