<?php 
/**
 * THIS FILE PROVIDES ASYNCHRONOUS JAVASCRIPT DRIVEN DATA FOR THE ACARS MAP // TRACKFLIGHT. 
 *  Replace this file in => INSTALLATION_FOLDER/lib/skins/iCrew/trackflight/
 * 
 * 
 * iCrew v4 Premium - Virtual Airline Crew Center
 * Copyright (c) 2017 iCrewSystems
 * 
 * This CrewCenter & and it's Modules (which are distinguished, and limited to unless specified)
 * are protected by copyright under Indian Copyright Act, 1957, with the 2012 amendments
 * No part of the website design or layout may be reproduced or transmitted in any form or by any other 
 * means electronic or mechanical to include photocopying, recording, reproducing, or electronic storage.
 * Any such act represents a copyright violation and theft of intellectual property owned by iCrewSystems. 
 * 
 * @author: Leonard Selvaraja
 * @copyright: Copyright (c) 2017, iCrewSystems
 * @link http://www.icrewsystems.com
 * @service name: iCrewSystems Virtual Airline Intermediate Services (with additions) 
 * Caution : NO SUPPORT WILL BE PROVIDED IF ANY MODULE / TEMPLATE IS FOUND TO BE TAMPERED WITH.
 */
?>

<style>
			.loading_text {
    		position: relative;
    		color: rgba(0, 0, 0, .3);
			}
			
			.loading_text:before {
    		content: attr(data-text);
    		position: absolute;
    		overflow: hidden;
    		max-width: 7em;
    		white-space: nowrap;
    		color: #000;
    		animation: loading 7s linear;
			}
			
			@keyframes loading {
    		0% {
        	max-width: 0;
	    	}
			}
		</style>
		
		
<div class="block" id="live_flights">
		<div class="block-title">
			<div class="block-options pull-right">
				<?php if(!$acarsdata)
					{ echo '<span class="label label-default">Receiver Offline</span>';}
					else
					{ echo '<span class="label label-muted animation-pulse">Live Feed only on iCrew</span>';}
				?>
				<!--<button id="trigger_button" class="btn btn-sm btn-default"><i class="fa fa-refresh"></i></button>-->
			</div>
			
			<h3><i class="gi gi-airplane"></i> <strong>Live </strong> Flights</h3>
		</div>
		
		<?php if(!$acarsdata) {
		} else {
		  echo '<div class="table-responsive"><table class="table table-responsive table-hover table-striped">
		<thead>
			<tr>
				<td>Airline</td>
				<td>Flight</td>
				<td>Pilot</td>
				<td>Departure</td>        
				<td>Arrival</td>
				<td>Status</td>
				<td>Progress</td>
				<td>Network</td>
				<td>Last updated</td>
				<td>LiveStream<sup><em><strong>+</strong></em></sup></td>
				<td>Options</td>
			</tr>
		</thead>';
		}
		?>
		<?php
		if(!$acarsdata)
		{ ?> 
			<div class="alert alert-info">
				<h3><strong>Oh Snap! ^_^ </strong></h3>
					No aircraft are in the air, and that's just `plane` wrong, don't you think? Register, Login, Make a bid and fly!
			</div> 
		<?php }
		else
		foreach($acarsdata as $flight)
		{ ?>
		<?php 
		/*ALGORITHM FOR FLIGHT PROGRESS*/
      $depicao = $flight->depicao;
      $arricao = $flight->arricao;
      $dist = OperationsData::getAirportDistance($depicao, $arricao);
      $distremain = $flight->distremain;
      $progress = 100 - (($distremain / $dist) * 100);
      $progressbar_val = floor($progress);
      if($progressbar_val < 10)
      {
        $progressbar_clr = 'info';
      }
      elseif($progressbar_val < 50)
      {
        $progressbar_clr = 'success';
      }
      elseif($progressbar_val < 80)
      {
        $progressbar_clr = 'warning';
      }
      elseif($progressbar_val < 100)
      {
        $progressbar_clr = 'danger';
      }
      
      /*The Progress Bar*/
      $progressbar = '<div class="progress progress-striped active">
      <div class="progress-bar progress-bar-'.$progressbar_clr.'" role="progressbar" aria-valuenow="'.$progressbar_val.'" aria-valuemin="0" aria-valuemax="100" style="width: '.$progressbar_val.'%"></div>
      </div>';
    ?>
      
		<tr>
		<td> <?php echo '<img src="'.fileurl('/lib/images/airline/'.$flight->code.'.png').'" alt="'.$airline->name.'" width="127px" height="auto;" />'; ?></td>
		<td><?php echo $flight->flightnum ?></td>
		<td><?php echo $flight->pilotname ?></td>
		<td><?php echo $flight->depicao ?></td>
		<td><?php echo $flight->arricao ?></td>
		<td><?php 
						$phase = $flight->phasedetail;
						if($phase == "Preflight")
						{
							echo '	<span class="label label-default">
										'. $phase .'
									</span>';
						}
						else if ($phase == "Taxiing to Runway")
						{
							echo '	<span class="label label-warning animation-pulse">
										'. $phase.'
									</span>';
						}
						else if ($phase == "Pushing Back")
						{
							echo '	<span class="label label-warning animation-pulse">
										'. $phase .'
									</span>';
						}
						else if ($phase == "Taking Off")
						{
							echo '	<span class="label label-primary animation-pulse">
									'. $phase.'
									</span>';
						}
						else if ($phase == "Climbing")
						{
							echo '	<span class="label label-primary animation-pulse">
									'. $phase .'
									</span>';
						}
						else if ($phase == "Cruising")
						{
							echo '	<span class="label label-success">
										'. $phase.' </span>';
						}
						else if ($phase == "Descending")
						{
							echo '	<span class="label label-warning animation-pulse">
										'. $phase .'
									</span>';
						}
						else if ($phase == "Approaching")
						{
							echo '	<span class="label label-primary animation-pulse">
										'. $phase .'
									</span>';
						}
						else if ($phase == "Final Approach")
						{
							echo '	<span class="label label-primary animation-pulse">
										'. $phase .'
									</span>';
						}
						else if ($phase == "Landing")
						{
							echo '	<span class="label label-primary animation-pulse">
										'. $phase .'
									</span>';
						}
						else if ($phase == "Taxiing to Gate")
						{
							echo '	<span class="label label-default animation-pulse">
										'. $phase .'
									</span>';
						}
						else 
						{
							echo '	<span class="label label-danger animation-pulse">
										'. $phase .'
									</span>';
						}
						
					?>	</td>
		<td><?php echo $progressbar; ?></td>
		<td><?php 
		// $this->set('acarsdata', ACARSData::GetACARSData());  
		if(!$flight->online)
		{ 
			echo 'OFFLINE';
		} 
		else {
			switch ($flight->online) {
				
				case 'IVAO': 
					echo '<img src="https://upload.wikimedia.org/wikipedia/commons/5/53/IVAO_Logo.png" style="width: 50px; height: auto;">';
				break;
				
				case 'VATSIM': 
					echo '<img src="https://fselitemedia.nyc3.digitaloceanspaces.com/fselite/2018/08/vatsim.jpg" style="width: 90px; height: auto;">';
				break;
				
				default:
					echo $flight->online;
				break;
			}
			}
			?></td>
		<td><?php echo date("H:i:s"); ?> UTC</td>
		<td>
		  <?php
		        $livesettings = PilotData::GetFieldValue($flight->pilotid, 'Show Live Stream');
		        $liveid = PilotData::GetFieldValue($flight->pilotid, 'Live Stream ID');
		        $liveplatform =  PilotData::GetFieldValue($flight->pilotid, 'Live Stream Platform');
		        if($liveplatform == 'YouTube')
		        {
		          $url = "https://www.youtube.com/channel/";
		        }
		        else if($liveplatform == 'Twitch')
		        {
		          $url = "https://go.twitch.tv/";
		        }
		        
		        $hrefurl = $url.''.$liveid;
		        if($livesettings == 'Yes')
		        {
		          echo '<a target="_blank" href="'.$hrefurl.'" class="btn btn-success btn-alt"> Watch</a>';
		        }
		        else
		        {
		          echo '<span class="text-muted">Not streaming</span>';
		        }
		        
		      ?>
		
		
		
		</td>
		<td><a target="_blank" href="<?php echo SITE_URL; ?>/index.php/trackflight/flightinfo/<?php echo $flight->id; ?>?pid=<?php echo $flight->pilotid; ?>&flt=<?php echo $flight->flightnum; ?>"><button type="button" class="btn btn-sm btn-info">Track Flight</button></a></td>
		</tr>
		<?php
		}
		?>
		</table>
		</div></div>


<script>
    $(document).ready(function() {
    	$.ajaxSetup({ cache: false }); // This part addresses an IE bug.  without it, IE will only load the first number and will never refresh
			setInterval(function() {
				$('#live_flights').load('<?php echo SITE_URL; ?>/live_uplink.php').fadeIn("slow");
			}, 5000);
    });
</script>