<?php
	if(!$allaircrafts)
	{
		echo '<div id="error">No Aircrafts!</div>';
		return;
	}
?>

<div class="content-header">
    <div class="header-section">
        <h1>
            <i class="fa fa-plane"></i><strong>Fleet</strong> Tracker<br><small>Flight Operations | <?php echo SITE_NAME?> &copy; <?php echo date("Y"); ?></small>
        </h1>
    </div>
</div>

<div class="row">
	<div class="col-md-12">
	  <div class="alert alert-info alert-dismissable animation fadeIn">
	    There are currently <?php $fleetdata = StatsData::TotalAircraftInFleet(); echo $fleetdata; ?> aircrafts in our fleet, if you feel this list is not updated, contact the staff!
	  </div>
		<div class="block">
			<div class="block-title">
				<h3><strong>Fleet</strong> Map</h3>
			</div>
			<p><?php MainController::Run('vFleetTracker', 'viewallmap');?></p>
		</div>
	</div>
</div>

<div class="row">
	<div class="col-md-12">
		<div class="block">
			<div class="block-title">
				<h3><strong>Fleet</strong> Details</h3>
			</div>
			<table id="tabledlist" class="table table-hover table-striped">
<thead>
<tr>
	<thead>
		<th>ICAO</th>
	  <th>Registration</th>
	  <th>Last Flight</th>
    <th>Location</th>
    <th>Total Flights</th>
    <th>Total Hours</th>
    <th>Total Miles</th>
    	<th>View</th>
	</thead>
	
</tr>
</thead>
<tbody>
<?php
foreach($allaircrafts as $aircraft)
{
	$lastflight = vFleetTrackData::getLastFlightAircraft($aircraft->id);
	if($lastflight)
	{		
		$last = '<a class="btn btn-default btn-sm" href="'.url('/pireps/view/'.$lastflight->pirepid).'">'.$lastflight->code.$lastflight->flightnum.' ('.$lastflight->depicao.' - '.$lastflight->arricao.')</a>';
	}
	else
	{
		$last = '<span class="text-danger">No Flights yet, new to fleet!</span>';	
	}
	
	$location = vFleetTrackData::getLastFlightAircraft($aircraft->id);
	if($location)
	{		
		$lastlocation = $location->arricao;
	}
	else
	{
		$lastlocation = 'N/A';	
	}
	
?>
<tr>
	<td><?php echo $aircraft->icao;?></td>
	<td><?php echo $aircraft->registration;?></td>
	<td><?php echo $last;?></td>
    <td><?php echo $lastlocation;?></td>
    <td><?php echo vFleetTrackData::countFlights($aircraft->id);?></td>
    <td><?php echo round(vFleetTrackData::countHours($aircraft->id));?></td>
    <td><?php echo round(vFleetTrackData::countMiles($aircraft->id));?> nm</td>
    <td><a class="btn btn-info btn-sm" href="<?php echo url('/vFleetTracker/view/'.$aircraft->registration);?>">View Aircraft</a></td>
<?php
}
?>
</tbody>
</table>
		</div>
	</div>
</div>
