
<div class="content-header">
    <div class="header-section">
        <h1>
            <i class="fa fa-plane"></i><strong>Fleet</strong> Tracker<br><small>Flight Operations | <?php echo SITE_NAME ?> &copy; <?php echo date("Y"); ?></small>
        </h1>
    </div>
</div>

<div class="row">
	<div class="col-md-12">
		<div class="block">
			<div class="block-title">
				<h3><?php echo SITE_NAME?>'s Fleet Tracker For <?php echo $aircraft->fullname;?> (<?php echo $aircraft->registration;?>)</h3>
			</div>

      <div class="table-responsive">
        <table class="table table-hover">
          <thead>
            <th>ICAO</th>
            <th>Name</th>
            <th>Full Name</th>
            <th>Registration</th>
            <th>Range</th>
            <th>Weight</th>
            <th>Cruise</th>
            <th>Passengers</th>
            <th>Cargo</th>
          </thead>
          <tbody>
            <td><?php echo $aircraft->icao;?></td>
            <td><?php echo $aircraft->name;?></td>
            <td><?php echo $aircraft->fullname;?></td>
            <td><span class="text-success"><?php echo $aircraft->registration;?></span></td>
            <td><?php echo $aircraft->range;?></td>
            <td><?php echo $aircraft->weight;?></td>
            <td><?php echo $aircraft->cruise;?></td>
            <td><?php echo $aircraft->maxpax;?></td>
            <td><?php echo $aircraft->maxcargo;?></td>
            
          </tbody>
        </table>
      </div>
    </div>
		<div class="block">
			<div class="block-title">
				<h3>Aircraft <strong>Image</strong></h3>
				
			</div>
			<center>
				<?php if(!empty($aircraft->imagelink))
{
	echo '<img src="'.$aircraft->imagelink.'" height="70%" width="70%" /><br /><br />';
}
else
{
	echo 'No Aircraft Image Yet!';
}
?>
			</center>
		</div>
<div class="block">
  <div class="block-title">
    <h3>Aircraft Stats</h3>
  </div>

<strong>Total Miles: </strong><?php echo round(vFleetTrackData::countMiles($aircraft->id));?>
<br />
<strong>Total Hours: </strong><?php echo round(vFleetTrackData::countHours($aircraft->id));?>
<br />
<strong>Total Flights: </strong><?php echo vFleetTrackData::countFlights($aircraft->id);?>
<br />
<?php if(count(vFleetTrackData::CargoAircraft($aircraft->id)) > 0)
{
?>
<strong>Total Passengers Carried: </strong><?php echo vFleetTrackData::countPassengers($aircraft->id);?>
<br />
<?php
}
else
{
?>
<strong>Total Cargo Carried: </strong><?php echo round(vFleetTrackData::countPassengers($aircraft->id));?>
<br />
<?php
}
?>
<h3>Current Aircraft Location</h3>
<?php
$location = vFleetTrackData::getLastFlightAircraft($aircraft->id);
if($location)
{
	$airport = OperationsData::getAirportInfo($location->arricao);
?>
<div class="mapcenter" align="center">
<div id="currentlocation" style="width: 960px; height: 520px;"></div>
</div>

<script type="text/javascript">
var options = {
	zoom: 12,
	mapTypeId: google.maps.MapTypeId.ROADMAP,
	styles: [ {
        "featureType": "landscape",
        "stylers": [ {
            "color": "#24282d"
        }
        ]
    }
    ,
    {
        "featureType": "administrative",
        "stylers": [ {
            "visibility": "off"
        }
        ]
    }
    ,
    {
        "featureType": "transit",
        "stylers": [ {
            "visibility": "off"
        }
        ]
    }
    ,
    {
        "featureType": "road",
        "stylers": [ {
            "visibility": "off"
        }
        ]
    }
    ,
    {
        "featureType": "water",
        "stylers": [ {
            "color": "#303844"
        }
        ]
    }
    ,
    {
        "featureType": "poi",
        "stylers": [ {
            "visibility": "off"
        }
        ]
    }
    ,
    {
        featureType: "all",
        elementType: "labels",
        stylers: [ {
            visibility: "off"
        }
        ]
    }
    ]
	
}

var map = new google.maps.Map(document.getElementById("currentlocation"), options);
var flightMarkers = [];
current_location = new google.maps.LatLng(<?php echo $airport->lat?>, <?php echo $airport->lng?>);
flightMarkers[flightMarkers.length] = new google.maps.Marker({
		position: current_location,
		map: map,
		title: "<?php echo "$airport->name ($airport->icao)";?>"
		
	});

if(flightMarkers.length > 0)
{
	var bounds = new google.maps.LatLngBounds();
	for(var i = 0; i < flightMarkers.length; i++) {
		bounds.extend(flightMarkers[i].position);
	}
}

map.fitBounds(bounds); 
</script>
<?php
}
else
{
	echo 'There is no aircraft location yet!';
}
?>


<!--<h3>Latest 15 Flights List</h3>
<?php MainController::Run('vFleetTracker', 'buildLastFlightTable', $aircraft->id, 15);?>

<h3>Latest 15 Flights Map</h3>
<?php
//There are two different types of maps you can use. The GCMap or the Google Map.
//To use Google Map, uncomment the google map part and comment in the GCMap.
?>

<?php
	$pirep_list = vFleetTrackData::getLastNumFlightsAircraft($aircraft->id, 15);							
	$gcstrg = "";
	foreach($pirep_list as $pirep)
	{	
		$gcstrg = $gcstrg.$pirep->depicao.'+-+'.$pirep->arricao.',+';
	}									
?>

<img src="http://www.gcmap.com/map?P=<?php echo $gcstrg ?>" /><br />
Maps generated by the <a href="http://www.gcmap.com/">Great Circle Mapper</a>&nbsp;- copyright &copy <a href="http://www.kls2.com/~karl/">Karl L. Swartz</a>
-->
<?php
/*
<div class="mapcenter" align="center">
<div id="routemap" style="width: 960px; height: 520px;"></div>
</div>

<script type="text/javascript">
var options = {
	mapTypeId: google.maps.MapTypeId.ROADMAP
}

var map = new google.maps.Map(document.getElementById("routemap"), options);
var flightMarkers = [];

<?php 
$shown = array();
$pirep_list = vFleetTrackData::getLastNumFlightsAircraft($aircraft->id, 15);
foreach($pirep_list as $pirep) {	
	// Dont show repeated routes		
	if(in_array($pirep->code.$pirep->flightnum, $shown))
		continue;
	else
		$shown[] = $pirep->code.$pirep->flightnum;
	
	if(empty($pirep->arrlat) || empty($pirep->arrlng)
		|| empty($pirep->deplat) || empty($pirep->deplng))
	{
		continue;
	}
?>
	dep_location = new google.maps.LatLng(<?php echo $pirep->deplat?>, <?php echo $pirep->deplng?>);
	arr_location = new google.maps.LatLng(<?php echo $pirep->arrlat?>, <?php echo $pirep->arrlng?>);

	flightMarkers[flightMarkers.length] = new google.maps.Marker({
		position: dep_location,
		map: map,
		title: "<?php echo "$pirep->depname ($pirep->depicao)";?>"
	});

	flightMarkers[flightMarkers.length] = new google.maps.Marker({
		position: arr_location,
		map: map,
		title: "<?php echo "$pirep->arrname ($pirep->arricao)";?>"
	});

	var flightPath = new google.maps.Polyline({
		path: [dep_location, arr_location],
		geodesic: true,
		strokeColor: "#FF0000", strokeOpacity: 0.5, strokeWeight: 2
	}).setMap(map);
<?php
}
?>

if(flightMarkers.length > 0)
{
	var bounds = new google.maps.LatLngBounds();
	for(var i = 0; i < flightMarkers.length; i++) {
		bounds.extend(flightMarkers[i].position);
	}
}

map.fitBounds(bounds); 
</script>
*/
?>

<!--<h3>Available Flights</h3>

<?php MainController::Run('vFleetTracker', 'buildFlightsAvbTable', $aircraft->id);?>
		-->	
			
		</div>
	</div>
</div>
