<!DOCTYPE html>
<html lang="zxx" class="no-js">
<head>
	<!-- Mobile Specific Meta -->
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<!-- Favicon-->
	<link rel="shortcut icon" href="img/flightops.png">
	<!-- Author Meta -->
	<meta name="author" content="CodePixar">
	<!-- Meta Description -->
	<meta name="description" content="">
	<!-- Meta Keyword -->
	<meta name="keywords" content="">
	<!-- meta character set -->
	<meta charset="UTF-8">
	<!-- Site Title -->
	<title>Legal Documentation</title>

	<link href="https://fonts.googleapis.com/css?family=Poppins:300,500,600" rel="stylesheet">
		<!--
		CSS
		============================================= -->
		<link rel="stylesheet" href="css/linearicons.css">
		<link rel="stylesheet" href="css/owl.carousel.css">
		<link rel="stylesheet" href="css/font-awesome.min.css">
		<link rel="stylesheet" href="css/nice-select.css">
		<link rel="stylesheet" href="css/magnific-popup.css">
		<link rel="stylesheet" href="css/bootstrap.css">
		<link rel="stylesheet" href="css/main.css">

		<?php 
			include('../core/codon.config.php');
			include('../core/local.config.php');
		?>

	</head>
	<body onload="checkCookie()">
		<div class="main-wrapper-first">
			<header>
				<div class="container">
					<div class="header-wrap">
						<div class="header-top d-flex justify-content-between align-items-center">
							<div class="logo">
							</div>
							<div class="main-menubar d-flex align-items-center">
								<nav class="hide">
									<a href="">Home</a>
									<a href="<?php echo SITE_URL; ?>">Crew Center</a>
								</nav>
								<div class="menu-bar"><span class="lnr lnr-menu"></span></div>
							</div>
						</div>
					</div>
				</div>
			</header>
			<div class="banner-area">
				<div class="container">
					<div class="row justify-content-center height align-items-center">
						<div class="col-lg-8">
							<div class="banner-content text-center">
								<span class="text-white top text-uppercase">
									<img src="img/logo.png" width="40%" height="auto;">
								 </span>
								<h1 class="text-white"><small>Privacy Policy & Legal</small></h1>
							</div>
						</div>
					</div>
				</div>
			</div>

			<!-- Start Feature Area -->
			<section class="featured-area">
				<div class="container">
					<div class="row">
						<div class="col-md-12">
							<h3 class="title text-uppercase">LEGAL</h3>
							<p>
								By accessing this website we assume you accept these terms and conditions in full. Do not continue to use <?php echo SITE_NAME; ?>’s website if you do not accept all of the terms and conditions stated on this page.
								<br><br>
								The following terminology applies to these Terms and Conditions, Privacy Statement and Disclaimer Notice and any or all Agreements: “Client”, “You” and “Your” refers to you, the person accessing this website and accepting the Company’s terms and conditions. “The Company”, “Ourselves”, “We”, “Our” and “Us”, refers to our Company. “Party”, “Parties”, or “Us”, refers to both the Client and ourselves, or either the Client or ourselves. All terms refer to the offer, acceptance and consideration of payment necessary to undertake the process of our assistance to the Client in the most appropriate manner, whether by formal meetings of a fixed duration, or any other means, for the express purpose of meeting the Client’s needs in respect of provision of the Company’s stated services, in accordance with and subject to, prevailing law of United Kingdom. Any use of the above terminology or other words in the singular, plural, capitalisation and/or he/she or they, are taken as interchangeable and therefore as referring to same.
							</p>
						</div>
						<div class="col-md-12">
							<h3 class="title text-uppercase">Introduction</h3>
							<p>
								This is a notice to inform you of our policy about all information that we record about you. It sets out the conditions under which we may process any information that we collect from you, or that you provide to us. It covers information that could identify you (“personal information”) and information that could not. In the context of the law and this notice, “process” means collect, store, transfer, use or otherwise act on information.
									<br><br>
									We regret that if there are one or more points below with which you are not happy, your only recourse is to leave our website immediately.
									<br><br>
									We take seriously the protection of your privacy and confidentiality. We understand that all visitors to our website are entitled to know that their personal data will not be used for any purpose unintended by them, and will not accidentally fall into the hands of a third party.
									<br><br>
									We undertake to preserve the confidentiality of all information you provide to us, and hope that you reciprocate.
									<br><br>
									Our policy complies with UK law accordingly implemented, including that required by the EU General Data Protection Regulation (GDPR).
									<br><br>
									The law requires us to tell you about your rights and our obligations to you in regards to the processing and control of your personal data. We do this now, by requesting that you read the information provided at knowyourprivacyrights.org
									<br><br>
									Except as set out below, we do not share, or sell, or disclose to a third party, any information collected through our website.
									<br><br>
							</p>
						</div>
						<div class="col-md-12">
							<h3 class="title text-uppercase"> Information We Process Because We Have A Contractual Obligation With You</h3>
							<p>
								When you create an account on our website, agree to our terms and conditions, a contract is formed between you and us.
								<br><br>
								In order to carry out our obligations under that contract we must process the information you give us. Some of this information may be personal information.
								<br><br>
								We may use it in order to verify your identity for security purposes
								and provide you with our services.<br><br>
								We process this information on the basis there is a contract between us, or that you have requested we use the information before we enter into a legal contract.
								<br><br>
								Additionally, we may aggregate this information in a general way and use it to provide class information, for example to monitor our performance with respect to a particular service we provide. If we use it for this purpose, you as an individual will not be personally identifiable.
								<br><br>
								We shall continue to process this information until the contract between us ends or is terminated by either party under the terms of the contract.
								<br><br>
								We make use of Anonymous IP addresses, honour “Do Not Track Requests” and enable support for user ‘opt-out’. More details on how to opt-out can be found here: <a href="https://tools.google.com/dlpage/gaoptout" target="_blank">https://tools.google.com/dlpage/gaoptout</a>
							</p>
						</div>

						<div class="col-md-12">
							<h3 class="title text-uppercase"> Information We Process Because We Have A Legal Obligation</h3>
							<p>
								We are subject to the law like everyone else. Sometimes, we must process your information in order to comply with a statutory obligation.
								<br><br>
								For example, we may be required to give information to legal authorities if they so request or if they have the proper authorisation such as a search warrant or court order.
								<br><br>
								This may include your personal information.
							</p>
						</div>

						<div class="col-md-12">
							<h3 class="title text-uppercase"> Job Application And Employment</h3>
							<p>
								If you wish to be a part of <?php echo SITE_NAME; ?> and decide to send us information in connection with a job application, we may keep it for up to one year in case we decide to contact you at a later date.
								<br><br>
								If we employ you, we collect information about you and your work from time to time
								throughout the period of your employment.
								<br><br>
								 This information will be used only for purposes directly relevant to your employment.
								  After your employment has ended, we will keep your file for one year before
									destroying or deleting it.
							</p>
						</div>

						<div class="col-md-12">
							<h3 class="title text-uppercase"> Complaints Regarding Content On Our Website</h3>
							<p>
								You are always welcomed to share your content such as : Scenery, Livries, Study Material
								 (to conduct specific approaches, etc).
								 We are committed to moderate user submitted content, but if there is any complaint from a user
								 / organisation
								  to take down the content contributed by you, given that the complaint has a valid reason
								 we may choose to delete the content without prior information.
								 <br><br>
								If you complain about any of the content on our website, we shall investigate your complaint.
								<br><br>
								If we feel it is justified or if we believe the law requires us to do so, we shall remove the content while we investigate.
								<br><br>
								If we think your complaint is vexatious or without any basis, we shall not correspond with you about it.
							</p>
						</div>

						<div class="col-md-12">
							<h3 class="title text-uppercase"> Sending A Message To Our Engineering Team</h3>
							<p>
																When you contact us, whether by telephone, through our website or by e-mail, we collect the data you have given to us in order to reply with the information you need.
								<br><br>
								We record your request and our reply in order to increase the efficiency of our operations.
								<br><br>
								We keep personally identifiable information associated with your message, such as your name and email address so as to be able to track our communications with you to provide a high quality service.
								<br><br>
								Data here is subject to the ‘right to data retrieval’.
							</p>
						</div>

						<div class="col-md-12">
							<h3 class="title text-uppercase">Cookies</h3>
							<p>
								Cookies are small text files that are placed on your computer’s hard drive by your web browser when you visit any website. They allow information gathered on one web page to be stored until it is needed for use on another, allowing a website to provide you with a personalised experience and the website owner with statistics about how you use the website so that it can be improved.
								<br><br>
								Some cookies may last for a defined period of time, such as one day or until you close your browser. Others last indefinitely. When you first reach <?php echo SITE_NAME; ?>, you will be asked to OPT-IN to our use of our cookies.
								<br><br>
								Your web browser should allow you to delete any you choose. It also should allow you to prevent or limit their use.
								<br><br>
								Our website uses cookies. They are placed by software that operates on our servers, and by software operated by third parties whose services we use.
								<br><br>
								When you first visit our website, we ask you whether you wish us to use cookies. If you choose not to accept them, we shall not use them for your visit except to record that you have not consented to their use for any other purpose.
								<br><br>
								If you choose not to use cookies or you prevent their use through your browser settings, you may not be able to use all the functionality of our website.
								<br><br>
								We use cookies in the following ways:
								<ul>
									<li>to track how you use our website</li>
									<li>to record whether you have seen specific notams we display on our website and fly the bidded flights</li>
										<li>to keep you signed in our site</li>
									</ul>
							</p>
						</div>

						<div class="col-md-12">
							<h3 class="title text-uppercase">  Access To Your Personal Information</h3>
							<p>
								At any time you may review or update personally identifiable information that we hold about you, by signing in to your account on our website.<br><br>
								To obtain a copy of any information that is not provided on our website you may send us (the Admins) a request using the iMail service within the iCrew center or email us at hro@<?php echo SITE_URL; ?><br><br>
								After receiving the request, we will tell you when we expect to provide you with the information, and whether we require any fee for providing it to you.<br><br>
								</p>
							</div>

							<div class="col-md-12">
								<h3 class="title text-uppercase">Removal Of Your Account</h3>
								<p>
									At anytime, if you wish to no longer be a member of our organisation, you may choose to delete your pilot account. Please note that this process is not reversible and you will be blocked from sending an application again to join with us.
								</p>
							</div>

							<div class="col-md-12">
								<h3 class="title text-uppercase">Verification Of Your Information</h3>
								<p>
									We are committed to protect your information and grant access to that information ONLY to you. In ensuring that, we urge the use of verifications which require you to have access to the E-mail ID which you used at the time of siging up with us.
									<br><br>This process cannot be done via iMail and requires you to have a valid email.
								</p>
							</div>

							<div class="col-md-12">
								<h3 class="title text-uppercase">Encryption Of Data Sent Between Us</h3>
								<p>
									We use Secure Sockets Layer (SSL) certificates to verify our identity to your browser and to encrypt any data you give us.
									<br><br>
									Whenever information is transferred between us, you can check that it is done so using SSL by looking for a closed padlock symbol or other trust mark in your browser’s URL bar or toolbar.
									<br><br>
									There may be occasions where some webpages display insecurely. This may be because of a broken image link or an outdated URL. Please get in touch if you have concerns.
								</p>
							</div>

							<div class="col-md-12">
								<h3 class="title text-uppercase">Compliance With The Law</h3>
								<p>
									Our privacy policy has been compiled so as to comply with the law of every country or legal jurisdiction in which we aim to do business. If you think it fails to satisfy the law of your jurisdiction, we should like to hear from you.
									<br><br>
									However, ultimately it is your choice as to whether you wish to use our website.
								</p>
							</div>

							<div class="col-md-12">
								<h3 class="title text-uppercase">Review Of This Privacy Policy</h3>
								<p>
									We may update this privacy notice from time to time as necessary. The terms that apply to you are those posted here on our website on the day you use our website. We advise you to print a copy for your records.
									<br><br>
									If you have any question regarding our privacy policy, please contact us at info@<?php echo SITE_URL; ?>
								</p>
							</div>
					</div>
				</div>
			</section>
			<!-- End Feature Area -->
			<!-- Start Amazing Works Area -->
		</div>
		<div class="main-wrapper">
			<!-- End Amazing Works Area -->
			<!-- Start Story Area -->
			<section class="story-area">
				<div class="container">
					<div class="row align-items-center">
						<div class="col-lg-3">
							<div class="story-title">
								<h3 class="text-white">Your information</h3>
								<span class="text-uppercase text-white">Is secured & encrypted</span>
							</div>
						</div>
						<div class="col-lg-6">
							<div class="story-box">
								<h6 class="text-uppercase">Not yet convinced?</h6>
								<p>If you change your mind on how we use cookies, you can revoke your previous choice by clicking on the button below. </p>
								<button onclick="deleteAllCookies()" class="primary-btn hover d-inline-flex align-items-center"><span class="mr-10">Clear cookies</span></button>
							</div>
						</div>
					</div>
				</div>
			</section>
			<!-- End Story Area -->
			<!-- Start Subscription Area -->
			<section class="subscription-area">
				<div class="container">
					<div class="row justify-content-center">
						<div class="col-lg-8">
							<div class="section-title text-center">
								<h3>This page was last edited on </h3>
								<span class="text-uppercase">21.4.2020 at 04:38z</span>
							</div>
						</div>
					</div>
				</div>
			</section>
			<!-- End Subscription Area -->
			<!-- Start Footer Widget Area -->
			<section class="footer-widget-area">
				<div class="container">
					<div class="row">
						<div class="col-md-4">
							<div class="single-widget d-flex flex-wrap justify-content-between">
								<div class="icon d-flex align-items-center justify-content-center">
									<span class="lnr lnr-pushpin"></span>
								</div>
								<div class="desc">
									<h6 class="title text-uppercase">Web Address</h6>
									<p>www.<?php echo SITE_URL; ?> &bull; icrew.<?php echo SITE_URL; ?> &bull; privacy.<?php echo SITE_URL; ?></p>
								</div>
							</div>
						</div>
						<div class="col-md-4">
							<div class="single-widget d-flex flex-wrap justify-content-between">
								<div class="icon d-flex align-items-center justify-content-center">
									<span class="lnr lnr-envelope"></span>
								</div>
								<div class="desc">
									<h6 class="title text-uppercase">Email Address</h6>
									<div class="contact">
										<a href="mailto:info@<?php echo SITE_URL; ?>">info@<?php echo SITE_URL; ?></a> <br>
										<a href="mailto:hro@<?php echo SITE_URL; ?>">hro@<?php echo SITE_URL; ?></a>
									</div>
								</div>
							</div>
						</div>
						<div class="col-md-4">
							<div class="single-widget d-flex flex-wrap justify-content-between">
								<div class="icon d-flex align-items-center justify-content-center">
									<span class="lnr lnr-earth"></span>
								</div>
								<div class="desc">
									<h6 class="title text-uppercase">Website Origin</h6>
									<div class="contact">
										<a href="javascript::void(0);">Washington State, United States of America</a>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>

		</div>


		<div id="cookie_directive_container" class="container" style="display: none">
        <nav class="navbar navbar-default navbar-fixed-bottom">

            <div class="container">
            <div class="navbar-inner navbar-content-center" id="cookie_accept">
                <p class="text-muted">
                  <br>
                  <h4 class="text-muted">Ahoy, we need your attention here</h4>
                  To make sure we provide you the best pilot experience, we use cookies. By using our website (<?php echo SITE_URL; ?> & icrew.<?php echo SITE_URL; ?>) you are consenting to our use of cookies in accordance with our cookie policy</a>.
                  <a href="#" class="btn btn-default pull-right">Close</a>
                </p>
              <br>
            </div>
          </div>

        </nav>
    </div>
		<script>
    jQuery(function($) {

    checkCookie_eu();

    function checkCookie_eu()
    {

        var consent = getCookie_eu("cookies_consent");

        if (consent == null || consent == "" || consent == undefined)
        {
            // show notification bar
            $('#cookie_directive_container').show();
        }

    }

    function setCookie_eu(c_name,value,exdays)
    {

        var exdate = new Date();
        exdate.setDate(exdate.getDate() + exdays);
        var c_value = escape(value) + ((exdays==null) ? "" : "; expires="+exdate.toUTCString());
        document.cookie = c_name + "=" + c_value+"; path=/";

        $('#cookie_directive_container').hide('slow');
    }


    function getCookie_eu(c_name)
    {
        var i,x,y,ARRcookies=document.cookie.split(";");
        for (i=0;i<ARRcookies.length;i++)
        {
            x=ARRcookies[i].substr(0,ARRcookies[i].indexOf("="));
            y=ARRcookies[i].substr(ARRcookies[i].indexOf("=")+1);
            x=x.replace(/^\s+|\s+$/g,"");
            if (x==c_name)
            {
                return unescape(y);
            }
        }
    }

    $("#cookie_accept a").click(function(){
        setCookie_eu("cookies_consent", 1, 30);
    });

});

function deleteAllCookies(){
	alert("Your cookies have been cleared!");
   var cookies = document.cookie.split(";");
   for (var i = 0; i < cookies.length; i++)
     deleteCookie(cookies[i].split("=")[0]);
}

function setCookie(name, value, expirydays) {
 var d = new Date();
 d.setTime(d.getTime() + (expirydays*24*60*60*1000));
 var expires = "expires="+ d.toUTCString();
 document.cookie = name + "=" + value + "; " + expires;
}

function deleteCookie(name){
  setCookie(name,"",-1);
}


</script>
<script>
function checkCookie() {
    // var user=getCookie("username");
    // if (user != "") {
    //     alert("Welcome again " + user);
    // } else {
    //    user = alert("Please enter your name:","");
    //    if (user != "" && user != null) {
    //        setCookie("username", user, 30);
    //    }
    // }
}
</script>
		<script src="js/vendor/jquery-2.2.4.min.js"></script>
		<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.11.0/umd/popper.min.js" integrity="sha384-b/U6ypiBEHpOf/4+1nzFpr53nxSS+GLCkfwBdFNTxtclqqenISfwAzpKaMNFNmj4" crossorigin="anonymous"></script>
		<script src="js/vendor/bootstrap.min.js"></script>
		<script src="js/jquery.ajaxchimp.min.js"></script>
		<script src="js/owl.carousel.min.js"></script>
		<script src="js/jquery.nice-select.min.js"></script>
		<script src="js/jquery.magnific-popup.min.js"></script>
		<script src="js/main.js"></script>
	</body>
</html>
