<?php 

/**
 * (c) 2023 iCrewTracker. All rights reserved.
 * 
 * This file is part of the iCrewTracker software suite.
 * Unauthorized copying, modification, distribution, or use of this file, 
 * via any medium, is strictly prohibited. This file is proprietary and confidential.
 * For license information, please see the LICENSE.md file.
 *
 * @author ICREWSYSTEMS SOFTWARE ENGINEERING LLP
 * @contact legal(at)icrewsystems.com 
 * @license UID cbb8060f-5d4c-45aa-8850-f4b8a87d0bcc
 * @package-bundle-hash:fe8Hghmq7t7GsZsW7KzHuTe/38L9upjcIflUqo8C5qr9iv/PeQNS
 */

 
namespace iCrewTracker\Controllers;

use Exception;
use iCrewTracker\Models\Pirep;
use iCrewTracker\Models\Pilots;
use iCrewTracker\Models\Airline;
use iCrewTracker\Models\Schedule;
use iCrewTracker\Base\BaseController;
use Illuminate\Database\Capsule\Manager as DB;

class ScheduleController extends BaseController {
        

    protected $fetchable_from_model = '*';

    
    /**
     * find_schedule_by_id
     *
     * @return void
     */
    public function find_schedule_by_id() {
        $id = $this->get('id');
        if($id) {            
            $schedule = Schedule::where('id', $id)->first();
            if(!is_null($schedule) && $schedule->count() != 0) {
                $is_bid = ($schedule->bidid != null || $schedule->bidid != 0) ? true : false;
                return $this->json([
                    // 'total' => $schedule->count(),
                    'is_bid' => $is_bid,
                    'bidded_pilot' => ($is_bid) ? Pilots::where('pilotid', $schedule->bidid)->first() : false,                    
                    'data' => $schedule,
                ]);      
            } 
        } 

        return $this->json([
            'total' => 0, 
            'message' => "No flights found with ID {$id}",
        ]);
    }
        
    /**
     * find_schedule_by_flightnumber
     *
     * @return void
     */
    public function find_schedule_by_flightnumber() {

        $flightnum = (string) $this->get('flightnum');
        if($flightnum) {
            $code = substr($flightnum, 0, 3);
            $number = substr($flightnum, 3);
            $schedule = Schedule::where('code', $code)->where('flightnum', $number)->first();

            if(!is_null($schedule) && $schedule->count() != 0) {

                $is_bid = ($schedule->bidid != null || $schedule->bidid != 0) ? true : false;

                return $this->json([
                    // 'total' => $schedule->count(),
                    'is_bid' => $is_bid,
                    'bidded_pilot' => ($is_bid) ? Pilots::where('pilotid', $schedule->bidid)->first() : false,                    
                    'data' => $schedule,
                ]);      
            } 
        } 

        return $this->json([
            'total' => 0, 
            'message' => "No flights found for {$flightnum}",
        ]);
    }
    
    /**
     * find_schedule_by_airports
     *
     * @return void
     */
    public function find_schedule_by_airports() {
        $dep = $this->get('depicao');
        $arr = $this->get('arricao');

        if($dep != false && $arr != false) {            
            $schedule = Schedule::where('depicao', $dep)
            ->where('arricao', $arr)->get();

            if($schedule->count() != 0) {
                return $this->json([
                    'total' => $schedule->count(),
                    'data' => $schedule,
                ]);      
            } 
        } else if($dep == false || $arr == false) {
            return $this->json([
                'total' => 0, 
                'message' => "Error: Departure and arrival airports were not passed in the URI",
            ]);    
        }

        return $this->json([
            'total' => 0, 
            'message' => "No flights found between {$dep} and {$arr}.",
        ]);
    }

    
    /**
     * find_current_bids
     *
     * @return void
     */
    public function find_current_bids() {

        $bids = DB::table('bids')->get();
        if($bids->count() != 0) {
            return $this->json([
                'total' => $bids->count(), 
                'data' => $bids
            ]);    
        }

        return $this->json([
            'total' => 0, 
            'message' => "No bids found",
        ]);
    }

    /**
     * get_all_pilots
     *
     * @return void
     */
    public function get_all_airlines() {
        $airlines = Airline::get();        
        return $this->json([
            'total' => $airlines->count(),
            'data' => $airlines->map(function($airline) {                
                $airline->total_pireps = Pirep::where('code', $airline->code)->count();
                $airline->total_schedules = Schedule::where('code', $airline->code)->count();  
                return $airline;
            }),
        ]);
    }
    
    /**
     * find_airline
     *
     * @return void
     */
    public function find_airline() {
        
        $code = (string) $this->get('code');


        if(!is_null($code) && strlen($code) == 3) {
            $airlines = Airline::where('code', $code)->get();            
            if($airlines == '[]') {

                return $this->json([
                    'message' => "No airline found with code {$code}",
                    'data' => false,
                ]);

                // throw new Exception("No pilot found with ID {$pilot_id}");
            } else {
                return $this->json(
                    [
                        'message' => 'Airline found',
                        'data' => $airlines->map(function($airline) {                
                            $airline->total_pireps = Pirep::where('code', $airline->code)->count();
                            $airline->total_schedules = Schedule::where('code', $airline->code)->count();  
                            return $airline;
                        }),
                    ]
                );    
            }
            
        } else {
            throw new Exception("Looks like the airline's IATA code was not passed in the URI // Invalid IATA code provided");
        }    
    }
}

?>