<?php 

/**
 * (c) 2023 iCrewTracker. All rights reserved.
 * 
 * This file is part of the iCrewTracker software suite.
 * Unauthorized copying, modification, distribution, or use of this file, 
 * via any medium, is strictly prohibited. This file is proprietary and confidential.
 * For license information, please see the LICENSE.md file.
 *
 * @author ICREWSYSTEMS SOFTWARE ENGINEERING LLP
 * @contact legal(at)icrewsystems.com 
 * @license UID cbb8060f-5d4c-45aa-8850-f4b8a87d0bcc
 * @package-bundle-hash:fe8Hghmq7t7GsZsW7KzHuTe/38L9upjcIflUqo8C5qr9iv/PeQNS
 */

namespace iCrewTracker\Models;

use Illuminate\Database\Eloquent\Model;

class Acars extends Model {
    
    protected $table = 'acarsdata'; 
    
    protected $primaryKey = 'id';
    public $incrementing = true;

    // Define which fields are fillable
    protected $fillable = [
        'pilotid', 'flightnum', 'pilotname', 'aircraft', 'lat', 'lng', 'heading', 'alt', 
        'gs', 'depicao', 'depapt', 'arricao', 'arrapt', 'deptime', 'timeremaining', 'arrtime', 
        'route', 'route_details', 'distremain', 'phasedetail', 'online', 'messagelog', 
        'lastupdate', 'client'
    ];

    // If you have any fields that should be treated as dates, you can add them to $dates
    protected $dates = [
        'lastupdate',
        'deptime',
        'arrtime'
    ];

    // If you don't want Eloquent to automatically manage created_at and updated_at timestamps, set it to false
    public $timestamps = false;
    
}

?>