<?php 

use iCrewTracker\Base\Config;
use Illuminate\Database\Capsule\Manager as Capsule;

// Static definitions. 
define('BASE_PATH', __DIR__);
define('APP_PATH', BASE_PATH . DIRECTORY_SEPARATOR . 'app');
define('CONFIG_PATH', APP_PATH . DIRECTORY_SEPARATOR . 'Config' . DIRECTORY_SEPARATOR . 'config.json');


ini_set('display_errors', 1); ini_set('display_startup_errors', 1); error_reporting(E_ALL);

// Example configurations array
Config::load((array) json_decode(file_get_contents(CONFIG_PATH)));
// die(print_r(file_get_contents(CONFIG_PATH)));

$config = Config::get('database');


# Using Illuminate Eloquent
$capsule = new Capsule;
$capsule->addConnection([
   "driver" => "mysql",
   "host" => $config->host,
   "database" => $config->name,
   "username" => $config->user,
   "password" => $config->pass,
   "prefix" => $config->prefix,
    // 'charset' => 'utf8',
    // 'collation' => 'utf8mb4_unicode_ci',
]);
$capsule->setAsGlobal();
$capsule->bootEloquent();

?>