<?php 
   Template::show('ICSTourAdmin/header');
   //CodonEvent::Dispatch('pirep_filed', 'PIREPS');
   ?>
<div class="row">
   <div class="col-md-12">
      <div class="card">
         <div class="card-body mx-4">
         	<h3>Step 1</h3>
            <!--Header-->
            <form class="form" action="<?php echo adminurl('ICSTourAdmin/process'); ?>" method="POST" enctype="multipart/form-data">
               <div class="md-form">
                  <label for="title">Tour Title</label>
                  <input type="text" required name="title"  class="form-control" placeholder="Title of your tour">
               </div>
               <div class="md-form">
                  <label for="title">Tour Description</label>
                  <textarea class="md-textarea form-control" name="description" placeholder="Describe the tour to your pilots"></textarea>
               </div>
               <div class="md-form">
                  <label for="title">Tour Total Legs</label>
                  <input type="text" required name="total_legs"  class="form-control" placeholder="Total Legs for your tour">
               </div>
               <div class="input-group">
                  <div class="input-group-prepend">
                     <span class="input-group-text" id="inputGroupFileAddon01">Tour Banner</span>
                  </div>
                  <div class="custom-file">
                     <input type="file" name="banner" required class="custom-file-input" id="inputGroupFile01" aria-describedby="inputGroupFileAddon01">
                     <label class="custom-file-label" for="inputGroupFile01">Choose file</label>
                  </div>
               </div>
               <div class="md-form">
                  <span class="input-text">Airline Code for your tour</span>
                  <select required name="airline" class="browser-default custom-select">
                     <?php 
                        foreach ($airlines as $airline) {
                        	?>
                     <option value="<?php echo $airline->code; ?>"><?php echo $airline->code; ?> - <?php echo $airline->name; ?></option>
                     <?php
                        }
                        ?>
                  </select>
               </div>
               <div class="md-form">
                  <span class="input-text">Airframes allowed on this tour
                  <br><small><span class="text-muted">To choose multiple airframes, use <code>CTRL</code> + <code>Left Click</code></span></small>
                  </span>
                  <br><br>
                  <select name="airframes[]" required class="browser-default custom-select" multiple>
                     <?php 
                        foreach ($aircrafts as $aircraft) {
                        	?>
                     <option value="<?php echo $aircraft->icao; ?>"><?php echo $aircraft->icao.' '.$aircraft->fullname; ?></option>
                     <?php
                        }
                        ?>
                  </select>
               </div>
               <div class="md-form">
                  <span class="input-text">Minimum Rank to fly this tour</span>
                  <select name="minrank" required class="browser-default custom-select">
                     <option value="0" selected>Allow all ranks</option>
                     <?php 
                        foreach ($ranks as $rank) {
                        	?>
                     <option value="<?php echo $rank->rankid; ?>"><?php echo $rank->rank; ?></option>
                     <?php
                        }
                        ?>
                  </select>
               </div>
                <div class="md-form">
                  <span class="input-text">Tour completion award</span>
                  <select name="minrank" required class="browser-default custom-select">
                     <option value="" selected>No Award</option>
                     <?php 
                        foreach ($awards as $award) {
                        	?>
                    			<option value="<?php echo $award->awardid; ?>"><?php echo $award->name; ?></option>
							<?php
                        }
                       ?>
                  </select>
               </div>
               <div class="md-form">
                  <input type="date" required name="startdate" class="form-control">
                  <label for="Form-email1">Tour Starting on</label>
               </div>
               <div class="md-form">
                  <input type="date" required name="enddate" class="form-control">
                  <label for="Form-email1">Tour ends on</label>
               </div>
               <label for="Form-email1">Tour Status?</label>
               <br>
               <div class="md-form">
                  <select name="active" class="browser-default custom-select">
                     <option value="0">Inactive (will not be shown to pilots)</option>
                     <option value="1" selected>Active (will be shown to pilots)</option>
                  </select>
               </div>
               <div class="text-center mb-3">
                  <input type="hidden" name="action" value="<?php echo $action; ?>" />
                  <input type="submit" name="submit" value="<?php echo $action; ?>" class="btn blue-gradient btn-block btn-rounded z-depth-1a" />
               </div>
         </div>
         </form>
      </div>
   </div>
</div>