<div class="container my-5">
   <!-- Section: Block Content -->
   <section>
      <div class="row">
         <div class="col-md-12">
         	<div class="alert alert-success alert-shadow">
         		We recommend assigning an aircraft for each class.
         		<br> Example:
         		LAND [Light: C172, Medium: B737, Heavy: B777], Rotary wings as well.
         		
         		<br><br>
         		<strong>
         			IF YOU ARE ADDING A NEW AIRCRAFT TO THE FLEET, MAKE SURE IT IS DISABLED SO THAT IT DOES NOT SHOW UP IN SCHEDULED 
         			SEARCHES
         		</strong>
         	</div>
         		<a href="<?php echo adminurl("operations/aircraft"); ?>" target="_new" style="text-decoration: none;" class="btn btn-sm btn-success btn-block">
					Add new aircraft
                </a>
                <br><br>
            <div class="card card-list">
               <div class="card-header white d-flex justify-content-between align-items-center py-3">
                  <p class="h5-responsive font-weight-bold mb-0">
                  	Available Aircrafts <span class="badge badge-danger ml-2"><?php echo count($allaircraft); ?></span></p>
               </div>
               <div class="card-body">
                  <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.css">
                  <script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.20/js/jquery.dataTables.js"></script>
                  <table class="table" id="hubstable">
                     <thead>
                        <tr>
                           <th>ICAO</th>
                           <th>Name/Type</th>
                           <th>Full Name</th>
                           <th>Registration</th>
                           <th align="center">Max Cargo</th>
                           <th>Options</th>
                        </tr>
                     </thead>
                     <?php 
                        if(count($allaircraft) > 0) {
                        	?>
                     <tbody>
                        <?php
                           foreach($allaircraft as $aircraft)
                           {
                           ?>
                        <tr class="<?php echo ($aircraft->enabled==0)?'disabled':''?>">
                           <td align="center"><?php echo $aircraft->icao; ?></td>
                           <td align="center"><?php echo $aircraft->name; ?></td>
                           <td align="center"><?php echo $aircraft->fullname; ?></td>
                           <td align="center"><?php echo $aircraft->registration; ?></td>
                           <td align="center"><?php echo $aircraft->maxcargo; ?></td>
                           <td align="center" width="1%" nowrap>
                           	<a href="<?php echo adminurl("CharterAdmin/assign/").$aircraft->id; ?>" style="text-decoration: none;" class="btn btn-sm btn-success">
                           		Assign to Charter Operations
                           	</a>
                           </td>
                        </tr>
                        <?php
                           }
                           ?>
                     </tbody>
                     <?php
                        } else {
                        	?>
                     <?php
                        }
                        ?>
                  </table>
               </div>
               <div class="card-footer white py-3 d-flex justify-content-between">
                  <button class="btn btn-primary btn-md px-3 my-0 mr-0">Add new hubs</button>
                  <button class="btn btn-light btn-md px-3 my-0 ml-0">View Pilots</button>
               </div>
            </div>
         </div>
      </div>
   </section>
   <!-- Section: Block Content -->
   <script>
      $('#hubstable').DataTable({});
   </script>
</div>