<div class="container my-5">
   <!-- Section: Block Content -->
   <section>
      <div class="row">
         <div class="col-md-12">
            <div class="card card-list">
               <div class="card-header white d-flex justify-content-between align-items-center py-3">
                  <p class="h5-responsive font-weight-bold mb-0">
                  	Aircrafts assigned for CharterOperations <span class="badge badge-danger ml-2"><?php echo count($allaircraft); ?></span></p>
               </div>
               <div class="card-body">
                  <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.css">
                  <script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.20/js/jquery.dataTables.js"></script>
                  <table class="table" id="hubstable">
                     <thead>
                        <tr>
                           <th>ICAO</th>
                           <th>Name/Type</th>
                           <th>Full Name</th>
                           <th>Registration</th>
                           <th align="center">Max Cargo</th>
                           <th>Options</th>
                        </tr>
                     </thead>
                     <?php 
                        if(count($allaircraft) > 0) {
                        	?>
                     <tbody>
                        <?php
                           foreach($allaircraft as $aircraft)
                           {
                           ?>
                        <tr>
                           <td align="center"><?php echo $aircraft->icao; ?></td>
                           <td align="center"><?php echo $aircraft->name; ?></td>
                           <td align="center"><?php echo $aircraft->fullname; ?></td>
                           <td align="center"><?php echo $aircraft->registration; ?></td>
                           <td align="center"><?php echo $aircraft->maxcargo; ?></td>
                           <td align="center" width="1%" nowrap>
                           	<a href="<?php echo adminurl("CharterAdmin/removefleet/").$aircraft->id; ?>" style="text-decoration: none;" class="btn btn-sm btn-danger">
                           		Remove assignment
                           	</a>
                           </td>
                        </tr>
                        <?php
                           }
                           ?>
                     </tbody>
                     <?php
                        } else {
                        	?>
                     <?php
                        }
                        ?>
                  </table>
               </div>
            </div>
         </div>
      </div>
   </section>
   <!-- Section: Block Content -->
   <script>
      $('#hubstable').DataTable({});
   </script>
</div>