  <div class="container my-5 py-5 z-depth-1">
 
    <!--Section: Content-->
    <section class="text-center px-md-5 mx-md-5 dark-grey-text">
    	<small><?php echo SITE_NAME; ?> Tour Center</small>
    	<br>
		<h3><strong><?php echo $title; ?></strong></h3>
	<?php 
		if($message) {
			?>
			<div class="alert alert-<?php echo $message_type; ?>">
				<?php echo $message; ?>
			</div>
			<?php
		}
	?>
	
	
	<div class="row">
		<div class="col-md-12 text-left">
			<?php
				
				
				
				
				foreach ($settings as $settings => $key) {
					switch ($settings) {
					
					
					case "airline_code": 
						$name = "Airline Code";
					break;
					
					case "cost_per_mile": 
						$name = "Cost Per Mile";
					break;
					
					case "process_hours": 
						$name = "Proces Pilot Hours";
					break;
					
					case "process_pay": 
						$name = "Proces Pilot Pay";
					break;
					
					case "welcome_message": 
						$name = "Welcome message";
					break;
					
					case "module_status": 
						$name = "Module Status";
					break;
					
					default: 
						$name = '';
					break;
					
				}
				
				
					// echo $name.' : ';
					// echo $key;
					
					// echo "<br>";
				}
			?>
			
			<form class="form" method="POST" action="<?php echo adminurl("CharterAdmin/update_settings"); ?>">
				<div class="form-group">
					<label>
						Module Status
					</label>
					<select name="module_status" class="form-control">
						<?php 
							$module_status = CharterData::getSettingValue('module_status');
							$enabled = '';
							$disabled = '';
							if($module_status == 1) {
								$enabled = "selected";
							} else {
								$disabled = "selected";
							}
						?>
						<option value="1" <?php echo $enabled; ?>>Enabled</option>
						<option value="0" <?php echo $disabled; ?>>Disabled</option>
					</select>
				</div>
				<div class="form-group">
					<label>
						Airline Code (Make sure Airline is added and set to "Disabled" so that it does not show up in scheduled searches)
					</label>
					<?php 
						$airline_code = CharterData::getSettingValue('airline_code');
					?>
						
					<input name="airline_code" class="form-control" value="<?php echo $airline_code; ?>" />
				</div>
				
				<div class="form-group">
					<label>
						Charter Module welcome message
					</label>
					<?php 
						$welcome_message = CharterData::getSettingValue('welcome_message');
					?>
						
					<textarea rows="3" name="welcome_message" class="form-control"><?php echo $welcome_message; ?></textarea>
				</div>
				
				<div class="form-group">
					<label>
						Credits Pay for Charter Operations
					</label>
					<select name="process_pay" class="form-control">
						<?php 
							$process_pay = CharterData::getSettingValue('process_pay');
								$enabled = '';
							$disabled = '';
							if($process_pay == 1) {
								$enabled = "selected";
							} else {
								$disabled = "selected";
							}
						?>
						<option value="1" <?php echo $enabled; ?>>Yes, pay the pilots</option>
						<option value="0" <?php echo $disabled; ?>>No, don't pay the pilots</option>
					</select>
				</div>
				
				<div class="form-group">
					<label>
						Credit Hours for Charter Operations
					</label>
					<select name="process_hours" class="form-control">
						<?php 
							$process_hours = CharterData::getSettingValue('process_hours');
							$enabled = '';
							$disabled = '';
							if($process_hours == 1) {
								$enabled = "selected";
							} else {
								$disabled = "selected";
							}
						?>
						<option value="1" <?php echo $enabled; ?>>Yes, credit the hours</option>
						<option value="0" <?php echo $disabled; ?>>No, don't credit the hours</option>
					</select>
				</div>
				
				<div class="form-group">
					<label>
						Charge pilots vMoney for creating Charter Flights?
					</label>
					<select name="charge_for_charter" class="form-control">
						<?php 
							$charge_for_charter = CharterData::getSettingValue('charge_for_charter');
							$enabled = '';
							$disabled = '';
							if($charge_for_charter == 1) {
								$enabled = "selected";
							} else {
								$disabled = "selected";
							}
						?>
						<option value="1" <?php echo $enabled; ?>>Yes, charge them</option>
						<option value="0" <?php echo $disabled; ?>>No, don't charge them anything</option>
					</select>
				</div>
				
				<div class="form-group">
					<label>
						How much to charge them per NM? (in <?php echo Config::get('MONEY_UNIT'); ?>)
					</label>
					<?php 
						if($charge_for_charter != 1) {
							$disabled = "disabled";
						} else {
							$disabled = "";
						}
						$cost_per_mile = CharterData::getSettingValue('cost_per_mile');
					?>
						
					<input <?php echo $disabled; ?> name="cost_per_mile" class="form-control" value="<?php echo $cost_per_mile; ?>" />
				</div>
				
				
				<div class="form-group">
					
					<input type="submit" value="Save" class="btn btn-info btn-md" />
				</div>
				
				
				
			</form>
		</div>
	</div>
    </section>
    <!--Section: Content-->
  </div>
	
