<?php

/**
 * (c) 2023 iCrewTracker. All rights reserved.
 * 
 * This file is part of the iCrewTracker software suite.
 * Unauthorized copying, modification, distribution, or use of this file, 
 * via any medium, is strictly prohibited. This file is proprietary and confidential.
 * For license information, please see the LICENSE.md file.
 *
 * @author ICREWSYSTEMS SOFTWARE ENGINEERING LLP
 * @contact legal(at)icrewsystems.com 
 * @license UID cbb8060f-5d4c-45aa-8850-f4b8a87d0bcc
 * @package-bundle-hash:fe8Hghmq7t7GsZsW7KzHuTe/38L9upjcIflUqo8C5qr9iv/PeQNS
 */

namespace iCrewTracker\Base;


class BaseController {

    /**
     * determineOutputType
     *
     * @param  mixed $request
     * @return void
     */
    protected function determineOutputType($request) {
        // Here's a simple example: check if the request has a 'format' parameter with value 'json'
        return isset($request['format']) && $request['format'] === 'json' ? 'json' : 'view';
    }
 
    /**
     * jsonResponse
     *
     * @param  mixed $data
     * @return void
     */
    protected function jsonResponse($data) {
    	if(empty($data)) {
    		throw new \Exception("empty data passed");	
    		exit;
    	} else {
    		header('Content-Type: application/json');
	        echo json_encode($data);
	        exit;	
    	}
    }
    
    /**
     * viewResponse
     *
     * @param  mixed $viewName
     * @param  mixed $data
     * @return void
     */
    protected function viewResponse($viewName, $data = []) {

        if(is_array($data)) {
            extract($data); // This will convert array keys to variables for use in the view
        }        
        include __DIR__ . "/../views/{$viewName}.php";
        exit;
    }

    /**
     * sendResponse
     *
     * @param  mixed $request
     * @param  mixed $data
     * @param  mixed $viewName
     * @return void
     */
    public function sendResponse($request, $data, $viewName) {
        $outputType = $this->determineOutputType($request);
        
        if ($outputType === 'json') {
            $this->jsonResponse($data);
        } else {
            $this->viewResponse($viewName, $data);
        }
    }
    
    /**
     * get
     *
     * @param  mixed $key
     * @param  mixed $default
     * @return void
     */
    protected function get($key, $default = false) {
        return isset($_GET[$key]) ? $_GET[$key] : $default;
    }

    /**
     * Retrieves a POST parameter by name.
     * 
     * @param string $key The key of the POST parameter to retrieve.
     * @param mixed $default The default value to return if the key does not exist.
     * @return mixed The value of the POST parameter, or the default value.
     */
    protected function post($key, $default = false) {
        return isset($_POST[$key]) ? $_POST[$key] : $default;
    }
    
    /**
     * json
     *
     * @param  mixed $data
     * @return void
     */
    public function json($data) {    
        return $this->jsonResponse($data);
    }
    
    /**
     * view
     *
     * @param  mixed $data
     * @param  mixed $view
     * @return void
     */
    public function view($view, mixed $data = null) {
        return $this->viewResponse($view, $data);
    }
}
