<?php 

/**
 * (c) 2023 iCrewTracker. All rights reserved.
 * 
 * This file is part of the iCrewTracker software suite.
 * Unauthorized copying, modification, distribution, or use of this file, 
 * via any medium, is strictly prohibited. This file is proprietary and confidential.
 * For license information, please see the LICENSE.md file.
 *
 * @author ICREWSYSTEMS SOFTWARE ENGINEERING LLP
 * @contact legal(at)icrewsystems.com 
 * @license UID cbb8060f-5d4c-45aa-8850-f4b8a87d0bcc
 * @package-bundle-hash:fe8Hghmq7t7GsZsW7KzHuTe/38L9upjcIflUqo8C5qr9iv/PeQNS
 */

 
namespace iCrewTracker\Controllers;

use Exception;
use iCrewTracker\Models\Pilots;
use iCrewTracker\Base\BaseController;

class AirlineController extends BaseController {
        

    protected $fetchable_from_model = ['firstname', 'lastname', 'code', 'pilotid', 'email', 'lastpirep', 'retired', 'confirmed', 'rank'];

    /**
     * get_all_pilots
     *
     * @return void
     */
    public function get_all_pilots() {
        $pilots = Pilots::select($this->fetchable_from_model)->get();        
        return $this->json([
            'total' => $pilots->count(),
            'data' => $pilots->map(function($pilot) {
                $pilot->pilot_va_id = $pilot->code.$pilot->pilotid;      
                $pilot->ivao_vid = null;
                $pilot->vatsim_cid = null;  
                return $pilot;
            }),
        ]);
    }

    public function find_pilot() {
        $pilot_id = $this->get('id');
        if(!is_null($pilot_id)) {
            $pilot = Pilots::select($this->fetchable_from_model)->where('pilotid', $pilot_id)->get();            
            if($pilot == '[]') {

                return $this->json([
                    'message' => "No pilot found with ID {$pilot_id}",
                    'data' => false,
                ]);

                // throw new Exception("No pilot found with ID {$pilot_id}");
            } else {
                return $this->json(
                    [
                        'message' => 'Pilot found',
                        'data' => $pilot->map(function($pilot) {
                            $pilot->pilot_va_id = $pilot->code.$pilot->pilotid;      
                            $pilot->ivao_vid = null;
                            $pilot->vatsim_cid = null;  
                            return $pilot;
                        }),
                    ]
                );    
            }
            
        } else {
            throw new Exception("Looks like pilot ID was not passed in the URI");
        }    
    }
}

?>